VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} MirrorForm 
   Caption         =   "UserForm1"
   ClientHeight    =   1305
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   2880
   OleObjectBlob   =   "MirrorForm.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "MirrorForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'    This is a part of the source code for Pro/DESKTOP.
'    Copyright (C) 1999-2002 Parametric Technology Corporation.
'    All rights reserved.
'

Option Explicit

'dialog strings

Private dlgTitle As String
Private dlgOK As String
Private dlgCancel As String
Private dlgWidth As String
Private dlgDepth As String
Private dlgHeight As String
Private dlgFace As String

'string constants
Private noPartDoc As String
Private notSaved As String
Private toolName As String
Private commitMirror As String

Private app As ProDESKTOP

Private partDoc As PartDocument

Private Sub cmdCancel_Click()
    Me.Hide
End Sub

Private Sub cmdOK_Click()

    On Error GoTo errorHandler

    Dim ret As Boolean
    ret = True
    
    Me.Hide
    
    Dim trans As zMatrix
    
    If optDepth Then
        Set trans = app.GetClass("Matrix").CreateMatrix(1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)
    ElseIf optWidth Then
        Set trans = app.GetClass("Matrix").CreateMatrix(-1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)
    ElseIf optHeight Then
        Set trans = app.GetClass("Matrix").CreateMatrix(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1)
    End If
        
    CreateMirrorComponent trans

    On Error GoTo 0
Exit Sub

errorHandler:
    Me.Hide
    MsgBox GetResourceString(96)

End Sub
Private Sub optDepth_Click()
    optDepth.Value = True
    optWidth.Value = False
    optHeight.Value = False
End Sub
Private Sub optHeight_Click()
    optDepth.Value = False
    optWidth.Value = False
    optHeight.Value = True
End Sub
Private Sub optWidth_Click()
    optDepth.Value = False
    optWidth.Value = True
    optHeight.Value = False
End Sub

Private Sub UserForm_Activate()
    On Error Resume Next
    Set partDoc = app.GetActiveDoc
    If partDoc Is Nothing Then
        'in case user runs by calling from another macro, check for doc type
        MsgBox GetResourceString(456), vbExclamation
        Unload Me
        Exit Sub
    Else
        If partDoc.GetDesign.GetFile.GetTitle = vbNullString Then
            'make sure part is saved
            MsgBox GetResourceString(103), vbExclamation
            Unload Me
            Exit Sub
        End If
    End If
    
    Me.Show
End Sub

Private Sub UserForm_Initialize()
    
    dlgTitle = GetResourceString(451)
    dlgOK = GetResourceString(91)
    dlgCancel = GetResourceString(92)
    dlgWidth = GetResourceString(452)
    dlgDepth = GetResourceString(453)
    dlgHeight = GetResourceString(454)
    dlgFace = GetResourceString(455)
    
    noPartDoc = GetResourceString(456)
    toolName = GetResourceString(457)
    commitMirror = GetResourceString(458)

    optWidth.Value = True
    optWidth.SetFocus
    
    optWidth.Caption = dlgWidth
    optDepth.Caption = dlgDepth
    optHeight.Caption = dlgHeight
    
    cmdOK.Caption = dlgOK
    cmdCancel.Caption = dlgCancel
    
    cmdOK.Default = True
    
    Me.Caption = dlgTitle
    
    Set app = CreateObject("ProDESKTOP.Application")
    app.SetVisible True
       
End Sub

Sub CreateMirrorComponent(trans As zMatrix)
    Dim des As aDesign
    Dim api As helm
    Dim mirrorPart As PartDocument
    Dim mirrorDesign As aDesign

    Dim comp As aDesign
    Dim tool As aTool
    
    Set des = partDoc.GetDesign
    
    Set api = app.TakeHelm
        
    Set mirrorPart = app.NewPart
    Set mirrorDesign = mirrorPart.GetDesign
    
    
    Set comp = mirrorDesign.CreateComponent(des, trans)
    comp.SetHidden 1
  
    Set tool = app.GetClass("Tool").CreateTool(mirrorDesign, comp, 1)
    tool.SetName toolName
   
    mirrorPart.UpdateDesign
    
    api.CommitCalls commitMirror, False
End Sub


